/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import $ from"jquery";import*as Helper from"@typo3/form/backend/form-editor/helper.js";import Icons from"@typo3/backend/icons.js";import Modal from"@typo3/backend/modal.js";import{MessageUtility}from"@typo3/backend/utility/message-utility.js";import Sortable from"sortablejs";import{selector}from"@typo3/core/literals.js";const defaultConfiguration={domElementClassNames:{buttonFormElementRemove:"formeditor-inspector-element-remove-button",collectionElement:"formeditor-inspector-collection-element",finisherEditorPrefix:"t3-form-inspector-finishers-editor-",inspectorEditor:"formeditor-inspector-element",inspectorInputGroup:"input-group",validatorEditorPrefix:"formeditor-inspector-validators-editor-"},domElementDataAttributeNames:{contentElementSelectorTarget:"data-insert-target",finisher:"data-finisher-identifier",validator:"data-validator-identifier",randomId:"data-random-id",randomIdTarget:"data-random-id-attribute",randomIdIndex:"data-random-id-number",maximumFileSize:"data-maximumFileSize"},domElementDataAttributeValues:{collapse:"actions-view-table-expand",editorControlsInputGroup:"inspectorEditorControlsGroup",editorWrapper:"editorWrapper",editorControlsWrapper:"inspectorEditorControlsWrapper",formElementHeaderEditor:"inspectorFormElementHeaderEditor",formElementSelectorControlsWrapper:"inspectorEditorFormElementSelectorControlsWrapper",formElementSelectorSplitButtonContainer:"inspectorEditorFormElementSelectorSplitButtonContainer",formElementSelectorSplitButtonListContainer:"inspectorEditorFormElementSelectorSplitButtonListContainer",iconNotAvailable:"actions-close",inspector:"inspector","Inspector-CheckboxEditor":"Inspector-CheckboxEditor","Inspector-CollectionElementHeaderEditor":"Inspector-CollectionElementHeaderEditor","Inspector-FinishersEditor":"Inspector-FinishersEditor","Inspector-FormElementHeaderEditor":"Inspector-FormElementHeaderEditor","Inspector-PropertyGridEditor":"Inspector-PropertyGridEditor","Inspector-RemoveElementEditor":"Inspector-RemoveElementEditor","Inspector-RequiredValidatorEditor":"Inspector-RequiredValidatorEditor","Inspector-SingleSelectEditor":"Inspector-SingleSelectEditor","Inspector-MultiSelectEditor":"Inspector-MultiSelectEditor","Inspector-GridColumnViewPortConfigurationEditor":"Inspector-GridColumnViewPortConfigurationEditor","Inspector-TextareaEditor":"Inspector-TextareaEditor","Inspector-TextEditor":"Inspector-TextEditor","Inspector-Typo3WinBrowserEditor":"Inspector-Typo3WinBrowserEditor","Inspector-ValidatorsEditor":"Inspector-ValidatorsEditor","Inspector-ValidationErrorMessageEditor":"Inspector-ValidationErrorMessageEditor",inspectorFinishers:"inspectorFinishers",inspectorValidators:"inspectorValidators",propertyGridEditorHeaderRow:"headerRow",propertyGridEditorAddRow:"addRow",propertyGridEditorAddRowItem:"addRowItem",propertyGridEditorContainer:"propertyGridContainer",propertyGridEditorDeleteRow:"deleteRow",propertyGridEditorLabel:"label",propertyGridEditorRowItem:"rowItem",propertyGridEditorColumn:"column",propertyGridEditorSelectValue:"selectValue",propertyGridEditorSortRow:"sortRow",propertyGridEditorValue:"value",viewportButton:"viewportButton"},domElementIdNames:{finisherPrefix:"t3-form-inspector-finishers-",validatorPrefix:"t3-form-inspector-validators-"},isSortable:!0};let configuration=null,formEditorApp=null;function getFormEditorApp(){return formEditorApp}function getViewModel(){return getFormEditorApp().getViewModel()}function getHelper(e){return getUtility().isUndefinedOrNull(e)?Helper.setConfiguration(configuration):Helper.setConfiguration(e)}function getUtility(){return getFormEditorApp().getUtility()}function assert(e,t,r){return getFormEditorApp().assert(e,t,r)}function getRootFormElement(){return getFormEditorApp().getRootFormElement()}function getCurrentlySelectedFormElement(){return getFormEditorApp().getCurrentlySelectedFormElement()}function getPublisherSubscriber(){return getFormEditorApp().getPublisherSubscriber()}function getFormElementDefinition(e,t){return getFormEditorApp().getFormElementDefinition(e,t)}function renderEditorDispatcher(e,t,r,o){switch(e.templateName){case"Inspector-FormElementHeaderEditor":renderFormElementHeaderEditor(e,t);break;case"Inspector-CollectionElementHeaderEditor":renderCollectionElementHeaderEditor(e,t,r,o);break;case"Inspector-MaximumFileSizeEditor":renderFileMaxSizeEditor(e,t);break;case"Inspector-TextEditor":renderTextEditor(e,t,r,o);break;case"Inspector-FinishersEditor":renderCollectionElementSelectionEditor("finishers",e,t);break;case"Inspector-ValidatorsEditor":renderCollectionElementSelectionEditor("validators",e,t);break;case"Inspector-ValidationErrorMessageEditor":renderValidationErrorMessageEditor(e,t);break;case"Inspector-RemoveElementEditor":renderRemoveElementEditor(e,t,r,o);break;case"Inspector-RequiredValidatorEditor":renderRequiredValidatorEditor(e,t,r,o);break;case"Inspector-CheckboxEditor":renderCheckboxEditor(e,t,r,o);break;case"Inspector-CountrySelectEditor":renderCountrySelectEditor(e,t,r,o);break;case"Inspector-SingleSelectEditor":renderSingleSelectEditor(e,t,r,o);break;case"Inspector-MultiSelectEditor":renderMultiSelectEditor(e,t,r,o);break;case"Inspector-GridColumnViewPortConfigurationEditor":renderGridColumnViewPortConfigurationEditor(e,t);break;case"Inspector-PropertyGridEditor":renderPropertyGridEditor(e,t,r,o);break;case"Inspector-TextareaEditor":renderTextareaEditor(e,t,r,o);break;case"Inspector-Typo3WinBrowserEditor":renderTypo3WinBrowserEditor(e,t,r,o)}getPublisherSubscriber().publish("view/inspector/editor/insert/perform",[e,t,r,o])}function openTypo3WinBrowser(e,t){Modal.advanced({type:Modal.types.iframe,content:TYPO3.settings.FormEditor.typo3WinBrowserUrl+"&mode="+e+"&bparams="+t,size:Modal.sizes.large})}function listenOnElementBrowser(){window.addEventListener("message",(function(e){if(!MessageUtility.verifyOrigin(e.origin))throw"Denied message sent by "+e.origin;if("typo3:elementBrowser:elementAdded"===e.data.actionName){if(void 0===e.data.fieldName)throw"fieldName not defined in message";if(void 0===e.data.value)throw"value not defined in message";const t=e.data.value.split("_");$(getHelper().getDomElementDataAttribute("contentElementSelectorTarget","bracesWithKeyValue",[e.data.fieldName])).val(t.pop()).trigger("paste")}}))}function getCollectionElementClass(e,t){return"finishers"===e?getHelper().getDomElementClassName("finisherEditorPrefix")+t:getHelper().getDomElementClassName("validatorEditorPrefix")+t}function getCollectionElementId(e,t,r){return"finishers"===e?getHelper().getDomElementIdName("finisherPrefix",r)+t:getHelper().getDomElementIdName("validatorPrefix",r)+t}function addSortableCollectionElementsEvents(e,t){e.addClass(getHelper().getDomElementClassName("sortable")),new Sortable(e.get(0),{draggable:getHelper().getDomElementClassName("collectionElement",!0),filter:"input,textarea,select",preventOnFilter:!1,animation:200,fallbackTolerance:200,swapThreshold:.6,dragClass:"formeditor-sortable-drag",ghostClass:"formeditor-sortable-ghost",onEnd:function(e){let r;r="finishers"===t?getHelper().getDomElementDataAttribute("finisher"):getHelper().getDomElementDataAttribute("validator");const o=$(e.item).attr(r),n=$(e.item).prevAll(getHelper().getDomElementClassName("collectionElement",!0)).first().attr(r),i=$(e.item).nextAll(getHelper().getDomElementClassName("collectionElement",!0)).first().attr(r);getPublisherSubscriber().publish("view/inspector/collectionElements/dnd/update",[o,n,i,t])}})}function setPropertyGridData(e,t,r,o){let n;if(t){const t=[];$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorContainer")+" "+getHelper().getDomElementDataIdentifierSelector("propertyGridEditorSelectValue")+":checked",$(e)).each((function(){n=$(this).closest(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorRowItem")).find(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorValue")).val(),getUtility().canBeInterpretedAsInteger(n)&&(n=parseInt(n,10)),t.push(n)})),getCurrentlySelectedFormElement().set(o+"defaultValue",t)}else n=$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorContainer")+" "+getHelper().getDomElementDataIdentifierSelector("propertyGridEditorSelectValue")+":checked",$(e)).first().closest(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorRowItem")).find(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorValue")).val(),getUtility().canBeInterpretedAsInteger(n)&&(n=parseInt(n,10)),getCurrentlySelectedFormElement().set(o+"defaultValue",n,!0);const i=[];$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorContainer")+" "+getHelper().getDomElementDataIdentifierSelector("propertyGridEditorRowItem"),$(e)).each((function(){let e=$(this).find(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorValue")).val();const t=$(this).find(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorLabel")).val();""===e&&(e=t);i.push({_label:t,_value:e})})),getCurrentlySelectedFormElement().set(o+r,i),validateCollectionElement(o+r,e)}function getEditorWrapperDomElement(e){return $(getHelper().getDomElementDataIdentifierSelector("editorWrapper"),$(e))}function getEditorControlsWrapperDomElement(e){return $(getHelper().getDomElementDataIdentifierSelector("editorControlsWrapper"),$(e))}function validateCollectionElement(e,t){let r,o,n;n=getFormEditorApp().validateCurrentlySelectedFormElementProperty(e),n.length>0?(getHelper().getTemplatePropertyDomElement("validationErrors",t).html('<span class="text-danger">'+n[0]+"</span>"),getViewModel().setElementValidationErrorClass(getEditorControlsWrapperDomElement(t),"hasError")):(getHelper().getTemplatePropertyDomElement("validationErrors",t).html(""),getViewModel().removeElementValidationErrorClass(getEditorControlsWrapperDomElement(t),"hasError")),n=getFormEditorApp().validateFormElement(getCurrentlySelectedFormElement()),o=e.split("."),o=o[0]+"."+o[1],r=!1;for(let e=0,t=n.length;e<t;++e)if(0===n[e].propertyPath.indexOf(o,0)&&n[e].validationResults&&n[e].validationResults.length>0){r=!0;break}r?getViewModel().setElementValidationErrorClass(getEditorControlsWrapperDomElement(t).closest(getHelper().getDomElementClassName("collectionElement",!0))):getViewModel().removeElementValidationErrorClass(getEditorControlsWrapperDomElement(t).closest(getHelper().getDomElementClassName("collectionElement",!0)))}function getFirstAvailableValidationErrorMessage(e,t){assert("array"===$.type(e),'Invalid configuration "errorCodes"',1489932939),assert("array"===$.type(t),'Invalid configuration "propertyData"',1489932940);for(let r=0,o=e.length;r<o;++r)for(let o=0,n=t.length;o<n;++o)if(parseInt(e[r],10)===parseInt(t[o].code,10)&&getUtility().isNonEmptyString(t[o].message))return t[o].message;return null}function renewValidationErrorMessages(e,t,r){if(assert("array"===$.type(t),'Invalid configuration "propertyData"',1489932942),!getUtility().isUndefinedOrNull(e)&&"array"===$.type(e)){const o=[];for(let n=0,i=e.length;n<i;++n){let i=!1;for(let o=0,l=t.length;o<l;++o)parseInt(e[n],10)===parseInt(t[o].code,10)&&(i=!0,getUtility().isNonEmptyString(r)?t[o].message=r:(t.splice(o,1),--l));i||getUtility().isNonEmptyString(r)&&o.push({code:e[n],message:r})}t=t.concat(o)}return t}function setRandomIds(e){assert("object"===$.type(e),'Invalid input "html"',1523904699),$(getHelper().getDomElementClassName("inspectorEditor",!0)).each((function(){const e=$(this),t={};$(getHelper().getDomElementDataAttribute("randomId","bracesWithKey"),e).each((function(){const e=$(this),r=e.attr(getHelper().getDomElementDataAttribute("randomIdTarget")),o=e.attr(getHelper().getDomElementDataAttribute("randomIdIndex"));e.is("["+r+"]")||(o in t||(t[o]="fe"+Math.floor(42*Math.random())+Date.now()),e.attr(r,t[o]))}))}))}export function getInspectorDomElement(){return $(getHelper().getDomElementDataIdentifierSelector("inspector"))}export function getFinishersContainerDomElement(){return $(getHelper().getDomElementDataIdentifierSelector("inspectorFinishers"),getInspectorDomElement())}export function getValidatorsContainerDomElement(){return $(getHelper().getDomElementDataIdentifierSelector("inspectorValidators"),getInspectorDomElement())}export function getCollectionElementDomElement(e,t){return"finishers"===e?$(getHelper().getDomElementDataAttribute("finisher","bracesWithKeyValue",[t]),getFinishersContainerDomElement()):$(getHelper().getDomElementDataAttribute("validator","bracesWithKeyValue",[t]),getValidatorsContainerDomElement())}export function renderEditors(e,t){getUtility().isUndefinedOrNull(e)&&(e=getCurrentlySelectedFormElement()),getInspectorDomElement().off().empty();const r=getFormElementDefinition(e,void 0);if("array"===$.type(r.editors)){for(let e=0,t=r.editors.length;e<t;++e){const t=getHelper().getTemplate(r.editors[e].templateName).clone();if(!t.length)continue;const o=$(t.html());$(o).first().addClass(getHelper().getDomElementClassName("inspectorEditor")),getInspectorDomElement().append($(o)),setRandomIds(o),renderEditorDispatcher(r.editors[e],o)}"function"===$.type(t)&&t()}}export function renderCollectionElementEditors(e,t){let r,o,n;assert(getUtility().isNonEmptyString(e),'Invalid parameter "collectionName"',1478354853),assert(getUtility().isNonEmptyString(t),'Invalid parameter "collectionElementIdentifier"',1478354854);const i=getFormEditorApp().getPropertyCollectionElementConfiguration(t,e);if("array"!==$.type(i.editors))return;const l=$("<div></div>").addClass(getHelper().getDomElementClassName("collectionElement")).addClass("panel").addClass("panel-default");"finishers"===e?(n=getFinishersContainerDomElement(),l.attr(getHelper().getDomElementDataAttribute("finisher"),t)):(n=getValidatorsContainerDomElement(),l.attr(getHelper().getDomElementDataAttribute("validator"),t)),n.append(l);const a=i.editors.length;a>0&&"header"===i.editors[0].identifier&&(o=document.createElement("div"),o.classList.add("panel-body"),r=document.createElement("div"),r.classList.add("panel-collapse","collapse"),r.id=getCollectionElementId(e,t),r.appendChild(o));for(let n=0;n<a;++n){const l=getHelper().getTemplate(i.editors[n].templateName).clone();if(!l.length)continue;const p=$(l.html());$(p).first().addClass(getCollectionElementClass(e,i.editors[n].identifier)).addClass(getHelper().getDomElementClassName("inspectorEditor")),0===n&&r?getCollectionElementDomElement(e,t).append(p).append(r):n===a-1&&r&&"removeButton"===i.editors[n].identifier||n>0&&r?o.append(p.get(0)):getCollectionElementDomElement(e,t).append(p),setRandomIds(p),renderEditorDispatcher(i.editors[n],p,t,e)}(2===a&&"header"===i.editors[0].identifier&&"removeButton"===i.editors[1].identifier||1===a&&"header"===i.editors[0].identifier)&&$(getHelper().getDomElementDataIdentifierSelector("collapse"),l).remove(),configuration.isSortable&&addSortableCollectionElementsEvents(n,e)}export function renderCollectionElementSelectionEditor(e,t,r){let o,n,i;assert(getUtility().isNonEmptyString(e),'Invalid configuration "collectionName"',1478362968),assert("object"===$.type(t),'Invalid parameter "editorConfiguration"',1475423098),assert("object"===$.type(r),'Invalid parameter "editorHtml"',1475423099),assert(getUtility().isNonEmptyString(t.label),'Invalid configuration "label"',1475423100),assert("array"===$.type(t.selectOptions),'Invalid configuration "selectOptions"',1475423101),"finishers"===e?(n=getFinishersContainerDomElement(),o=getRootFormElement().get(e)):(n=getValidatorsContainerDomElement(),o=getCurrentlySelectedFormElement().get(e)),n.off().empty(),getHelper().getTemplatePropertyDomElement("label",r).text(t.label);const l=getHelper().getTemplatePropertyDomElement("selectOptions",r),a=!getUtility().isUndefinedOrNull(o)&&o.length>0;if(a)for(let t=0,r=o.length;t<r;++t)getPublisherSubscriber().publish("view/inspector/collectionElement/existing/selected",[o[t].identifier,e]);i=!0;for(let e=0,r=t.selectOptions.length;e<r;++e){let r=!0;if(!getUtility().isUndefinedOrNull(o))for(let n=0,i=o.length;n<i;++n)if(o[n].identifier===t.selectOptions[e].value){r=!1;break}r&&(l.append(new Option(t.selectOptions[e].label,t.selectOptions[e].value)),""!==t.selectOptions[e].value&&(i=!1))}if(i){getHelper().getTemplatePropertyDomElement("select-group",r).off().empty().remove();const e=getHelper().getTemplatePropertyDomElement("label-no-select",r);a?e.text(t.label):e.remove()}else getHelper().getTemplatePropertyDomElement("label-no-select",r).remove(),l.on("change",(function(){if(""!==$(this).val()){const t=$(this).val();$(selector`option[value="${t}"]`,$(this)).remove(),getFormEditorApp().getPublisherSubscriber().publish("view/inspector/collectionElement/new/selected",[t,e])}}))}export function renderFormElementHeaderEditor(e,t){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1475421525),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1475421526),Icons.getIcon(getFormElementDefinition(getCurrentlySelectedFormElement(),"iconIdentifier"),Icons.sizes.small,null,Icons.states.default).then((function(e){getHelper().getTemplatePropertyDomElement("header-label",t).append($(e).addClass(getHelper().getDomElementClassName("icon"))).append(buildTitleByFormElement()).append("<code>"+getCurrentlySelectedFormElement().get("identifier")+"</code>")}))}export function renderCollectionElementHeaderEditor(e,t,r,o){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1475421258),assert(getUtility().isNonEmptyString(e.label),'Invalid configuration "label"',1475421257),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1475421259);const n=function(e){const n=getHelper().getTemplatePropertyDomElement("panel-icon",t);e?n.replaceWith(e):n.remove();const i=getFormEditorApp().getPropertyCollectionElementConfiguration(r,o).editors;if(!(2===i.length&&"header"===i[0].identifier&&"removeButton"===i[1].identifier||1===i.length&&"header"===i[0].identifier)){const e=document.createElement("button");e.classList.add("panel-button","collapsed"),e.setAttribute("type","button"),e.setAttribute("data-bs-toggle","collapse"),e.setAttribute("data-bs-target",getCollectionElementId(o,r,!0)),e.setAttribute("aria-expaned","false"),e.setAttribute("aria-controls",getCollectionElementId(o,r));const n=document.createElement("span");n.classList.add("caret"),getHelper().getTemplatePropertyDomElement("panel-heading-row",t).find(".panel-title").before(n),getHelper().getTemplatePropertyDomElement("panel-heading-row",t).wrapInner(e)}const l=getCollectionElementDomElement(o,r).get(0).querySelector(".formeditor-inspector-element-remove-button");if(l){const e=l.querySelector("button");e.classList.add("btn-sm"),e.querySelector(".btn-label").classList.add("visually-hidden");const r=document.createElement("div");r.classList.add("panel-actions"),r.append(e),getHelper().getTemplatePropertyDomElement("panel-heading-row",t).append(r)}l?.remove()},i=getFormEditorApp().getFormEditorDefinition(o,r);"iconIdentifier"in i?Icons.getIcon(i.iconIdentifier,Icons.sizes.small,null,Icons.states.default).then((function(e){n(e)})):n(),e.label&&getHelper().getTemplatePropertyDomElement("panel-title",t).removeAttr("data-template-property").append(e.label)}export function renderFileMaxSizeEditor(e,t){if(assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1475421258),assert(getUtility().isNonEmptyString(e.label),'Invalid configuration "label"',1475421257),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1475421259),e.label){const r=getHelper().getTemplatePropertyDomElement("label",t),o=r.attr(getHelper().getDomElementDataAttribute("maximumFileSize"));r.append(e.label.replace("{0}",o))}}export function renderTextEditor(e,t,r,o){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1475421053),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1475421054),assert(getUtility().isNonEmptyString(e.label),'Invalid configuration "label"',1475421055),assert(getUtility().isNonEmptyString(e.propertyPath),'Invalid configuration "propertyPath"',1475421056),getHelper().getTemplatePropertyDomElement("label",t).append(e.label),getUtility().isNonEmptyString(e.fieldExplanationText)?getHelper().getTemplatePropertyDomElement("fieldExplanationText",t).text(e.fieldExplanationText):getHelper().getTemplatePropertyDomElement("fieldExplanationText",t).remove(),getUtility().isNonEmptyString(e.placeholder)&&getHelper().getTemplatePropertyDomElement("propertyPath",t).attr("placeholder",e.placeholder);const n=getFormEditorApp().buildPropertyPath(e.propertyPath,r,o),i=getCurrentlySelectedFormElement().get(n);if(validateCollectionElement(n,t),getHelper().getTemplatePropertyDomElement("propertyPath",t).val(i),!getUtility().isUndefinedOrNull(e.additionalElementPropertyPaths)&&"array"===$.type(e.additionalElementPropertyPaths))for(let t=0,r=e.additionalElementPropertyPaths.length;t<r;++t)getCurrentlySelectedFormElement().set(e.additionalElementPropertyPaths[t],i);renderFormElementSelectorEditorAddition(e,t,n),getHelper().getTemplatePropertyDomElement("propertyPath",t).on("keyup paste",(function(){if(e.doNotSetIfPropertyValueIsEmpty&&!getUtility().isNonEmptyString($(this).val())?getCurrentlySelectedFormElement().unset(n):getCurrentlySelectedFormElement().set(n,$(this).val()),validateCollectionElement(n,t),!getUtility().isUndefinedOrNull(e.additionalElementPropertyPaths)&&"array"===$.type(e.additionalElementPropertyPaths))for(let t=0,r=e.additionalElementPropertyPaths.length;t<r;++t)e.doNotSetIfPropertyValueIsEmpty&&!getUtility().isNonEmptyString($(this).val())?getCurrentlySelectedFormElement().unset(e.additionalElementPropertyPaths[t]):getCurrentlySelectedFormElement().set(e.additionalElementPropertyPaths[t],$(this).val())}))}export function renderValidationErrorMessageEditor(e,t){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1489874121),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1489874122),assert(getUtility().isNonEmptyString(e.label),'Invalid configuration "label"',1489874123),assert(getUtility().isNonEmptyString(e.propertyPath),'Invalid configuration "propertyPath"',1489874124),getHelper().getTemplatePropertyDomElement("label",t).append(e.label),getUtility().isNonEmptyString(e.fieldExplanationText)?getHelper().getTemplatePropertyDomElement("fieldExplanationText",t).text(e.fieldExplanationText):getHelper().getTemplatePropertyDomElement("fieldExplanationText",t).remove();const r=getFormEditorApp().buildPropertyPath(e.propertyPath);let o=getCurrentlySelectedFormElement().get(r);if(!getUtility().isUndefinedOrNull(o)&&"array"===$.type(o)){const r=getFirstAvailableValidationErrorMessage(e.errorCodes,o);getUtility().isUndefinedOrNull(r)||getHelper().getTemplatePropertyDomElement("propertyPath",t).val(r)}getHelper().getTemplatePropertyDomElement("propertyPath",t).on("keyup paste",(function(){o=getCurrentlySelectedFormElement().get(r),getUtility().isUndefinedOrNull(o)&&(o=[]),getCurrentlySelectedFormElement().set(r,renewValidationErrorMessages(e.errorCodes,o,$(this).val()))}))}export function renderCountrySelectEditor(e,t,r,o){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1674826430),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1674826431),assert(getUtility().isNonEmptyString(e.label),'Invalid configuration "label"',1674826432);const n=getFormEditorApp().buildPropertyPath(e.propertyPath,r,o);getHelper().getTemplatePropertyDomElement("label",t).append(e.label);const i=getHelper().getTemplatePropertyDomElement("selectOptions",t),l=getCurrentlySelectedFormElement().get(n)||{},a=$("option",i);i.empty();for(let e=0,t=a.length;e<t;++e){let t=!1;for(const r of Object.keys(l))if(a[e].value===l[r]){t=!0;break}const r=new Option(a[e].text,e.toString(),!1,t);$(r).data({value:a[e].value}),i.append(r)}i.on("change",(function(){const e=[];$("option:selected",$(this)).each((function(){e.push($(this).data("value"))})),getCurrentlySelectedFormElement().set(n,e)}))}export function renderSingleSelectEditor(e,t,r,o){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1475421048),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1475421049),assert(getUtility().isNonEmptyString(e.label),'Invalid configuration "label"',1475421050),assert(getUtility().isNonEmptyString(e.propertyPath),'Invalid configuration "propertyPath"',1475421051),assert("array"===$.type(e.selectOptions),'Invalid configuration "selectOptions"',1475421052);const n=getFormEditorApp().buildPropertyPath(e.propertyPath,r,o);getHelper().getTemplatePropertyDomElement("label",t).append(e.label);const i=getHelper().getTemplatePropertyDomElement("selectOptions",t),l=getCurrentlySelectedFormElement().get(n);for(let t=0,r=e.selectOptions.length;t<r;++t){let r;r=e.selectOptions[t].value===l?new Option(e.selectOptions[t].label,t.toString(),!1,!0):new Option(e.selectOptions[t].label,t.toString()),$(r).data({value:e.selectOptions[t].value}),i.append(r)}i.on("change",(function(){getCurrentlySelectedFormElement().set(n,$("option:selected",$(this)).data("value"))}))}export function renderMultiSelectEditor(e,t,r,o){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1485712399),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1485712400),assert(getUtility().isNonEmptyString(e.label),'Invalid configuration "label"',1485712401),assert(getUtility().isNonEmptyString(e.propertyPath),'Invalid configuration "propertyPath"',1485712402),assert("array"===$.type(e.selectOptions),'Invalid configuration "selectOptions"',1485712403);const n=getFormEditorApp().buildPropertyPath(e.propertyPath,r,o);getHelper().getTemplatePropertyDomElement("label",t).append(e.label);const i=getHelper().getTemplatePropertyDomElement("selectOptions",t),l=getCurrentlySelectedFormElement().get(n)||{};for(let t=0,r=e.selectOptions.length;t<r;++t){let r=null;for(const o of Object.keys(l))if(e.selectOptions[t].value===l[o]){r=new Option(e.selectOptions[t].label,t.toString(),!1,!0);break}r||(r=new Option(e.selectOptions[t].label,t.toString())),$(r).data({value:e.selectOptions[t].value}),i.append(r)}i.on("change",(function(){const e=[];$("option:selected",$(this)).each((function(){e.push($(this).data("value"))})),getCurrentlySelectedFormElement().set(n,e)}))}export function renderGridColumnViewPortConfigurationEditor(e,t){if(assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1489528242),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1489528243),assert(getUtility().isNonEmptyString(e.label),'Invalid configuration "label"',1489528244),assert("array"===$.type(e.configurationOptions.viewPorts),'Invalid configurationOptions "viewPorts"',1489528245),assert(!getUtility().isUndefinedOrNull(e.configurationOptions.numbersOfColumnsToUse.label),'Invalid configurationOptions "numbersOfColumnsToUse"',1489528246),assert(!getUtility().isUndefinedOrNull(e.configurationOptions.numbersOfColumnsToUse.propertyPath),'Invalid configuration "selectOptions"',1489528247),!getFormElementDefinition(getCurrentlySelectedFormElement().get("__parentRenderable"),"_isGridRowFormElement"))return void t.remove();getHelper().getTemplatePropertyDomElement("label",t).append(e.label);const r=$(getHelper().getDomElementDataIdentifierSelector("viewportButton"),$(t)).clone();$(getHelper().getDomElementDataIdentifierSelector("viewportButton"),$(t)).remove();const o=getHelper().getTemplatePropertyDomElement("numbersOfColumnsToUse",$(t)).clone();getHelper().getTemplatePropertyDomElement("numbersOfColumnsToUse",$(t)).remove();const n=getEditorControlsWrapperDomElement(t),i=function(r){getHelper().getTemplatePropertyDomElement("numbersOfColumnsToUse",$(t)).off().empty().remove();const n=$(o).clone(!0,!0);getEditorWrapperDomElement(t).after(n),$("input",n).focus(),getHelper().getTemplatePropertyDomElement("numbersOfColumnsToUse-label",n).append(e.configurationOptions.numbersOfColumnsToUse.label.replace("{@viewPortLabel}",r.data("viewPortLabel"))),getHelper().getTemplatePropertyDomElement("numbersOfColumnsToUse-fieldExplanationText",n).append(e.configurationOptions.numbersOfColumnsToUse.fieldExplanationText);const i=e.configurationOptions.numbersOfColumnsToUse.propertyPath.replace("{@viewPortIdentifier}",r.data("viewPortIdentifier"));getHelper().getTemplatePropertyDomElement("numbersOfColumnsToUse-propertyPath",n).val(getCurrentlySelectedFormElement().get(i)),getHelper().getTemplatePropertyDomElement("numbersOfColumnsToUse-propertyPath",n).on("keyup paste change",(function(){const e=$(this);$.isNumeric(e.val())||e.val(""),getCurrentlySelectedFormElement().set(i,e.val())}))};for(let l=0,a=e.configurationOptions.viewPorts.length;l<a;++l){const p=e.configurationOptions.viewPorts[l].viewPortIdentifier,s=e.configurationOptions.viewPorts[l].label,d=$(r).clone(!0,!0);if(d.text(p),d.data("viewPortIdentifier",p),d.data("viewPortLabel",s),d.attr("title",s),n.append(d),l===a-1){const e=$(o).clone(!0,!0);getEditorWrapperDomElement(t).after(e),i(d),d.addClass(getHelper().getDomElementClassName("active"))}$("button",n).on("click",(function(){const e=$(this);$("button",n).removeClass(getHelper().getDomElementClassName("active")),e.addClass(getHelper().getDomElementClassName("active")),i(e)}))}}export function renderPropertyGridEditor(e,t,r,o){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1475419226),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1475419227),assert("boolean"===$.type(e.enableAddRow),'Invalid configuration "enableAddRow"',1475419228),assert("boolean"===$.type(e.enableDeleteRow),'Invalid configuration "enableDeleteRow"',1475419230),assert("boolean"===$.type(e.isSortable),'Invalid configuration "isSortable"',1475419229),assert(getUtility().isNonEmptyString(e.propertyPath),'Invalid configuration "propertyPath"',1475419231),assert(getUtility().isNonEmptyString(e.label),'Invalid configuration "label"',1475419232),getHelper().getTemplatePropertyDomElement("label",t).append(e.label),getUtility().isNonEmptyString(e.fieldExplanationText)?getHelper().getTemplatePropertyDomElement("fieldExplanationText",t).text(e.fieldExplanationText):getHelper().getTemplatePropertyDomElement("fieldExplanationText",t).remove();let n,i=getFormEditorApp().buildPropertyPath(void 0,r,o,void 0,!0);getUtility().isNonEmptyString(i)&&(i+="."),n=!!getUtility().isUndefinedOrNull(e.useLabelAsFallbackValue)||e.useLabelAsFallbackValue;let l=[{name:"label",title:"Label"},{name:"value",title:"Value"},{name:"selected",title:"Selected"}];getUtility().isNonEmptyArray(e.gridColumns)&&(l=e.gridColumns);const a=l.map((function(e){return e.name})),p=l.map((function(e){return e.title||null}));let s;$([getHelper().getDomElementDataIdentifierSelector("propertyGridEditorHeaderRow"),getHelper().getDomElementDataIdentifierSelector("propertyGridEditorRowItem"),getHelper().getDomElementDataIdentifierSelector("propertyGridEditorAddRowItem")].join(","),$(t)).each((function(e,t){const r=$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorColumn"),t),o=r.last().nextAll(),n={};r.detach().each((function(e,t){const r=$(t),o=r.data("column");a.includes(o)&&(n[o]=r)})),a.forEach((function(e,r){const o=n[e];o.is("th")&&o.append(p[r]),o.appendTo(t)})),o.appendTo(t)})),s=!getUtility().isUndefinedOrNull(e.multiSelection)&&!!e.multiSelection;const d=$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorRowItem"),$(t)).clone();if($(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorRowItem"),$(t)).remove(),e.enableDeleteRow?$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorDeleteRow"),$(d)).on("click",(function(){$(this).closest(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorRowItem")).off().empty().remove(),setPropertyGridData($(t),s,e.propertyPath,i)})):$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorDeleteRow"),$(d)).parent().off().empty(),e.isSortable?$(t).get(0).querySelectorAll(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorContainer")+" tbody").forEach((function(r){new Sortable(r,{group:getHelper().getDomElementDataAttributeValue("propertyGridEditorContainer"),handle:getHelper().getDomElementDataIdentifierSelector("propertyGridEditorSortRow"),draggable:getHelper().getDomElementDataIdentifierSelector("propertyGridEditorRowItem"),pull:"clone",swapThreshold:.6,dragClass:"formeditor-sortable-drag",ghostClass:"formeditor-sortable-ghost",onUpdate:function(){setPropertyGridData($(t),s,e.propertyPath,i)}})})):$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorSortRow"),$(d)).parent().off().empty(),$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorSelectValue"),$(d)).on("change",(function(){s||$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorSelectValue")+":checked",$(t)).not($(this)).prop("checked",!1),setPropertyGridData($(t),s,e.propertyPath,i)})),$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorLabel")+","+getHelper().getDomElementDataIdentifierSelector("propertyGridEditorValue"),$(d)).on("keyup paste",(function(){setPropertyGridData($(t),s,e.propertyPath,i)})),n&&$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorLabel"),$(d)).on("focusout",(function(){""===$(this).closest(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorRowItem")).find(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorValue")).val()&&$(this).closest(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorRowItem")).find(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorValue")).val($(this).val())})),e.enableAddRow){const r=$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorAddRowItem"),$(t)).clone();$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorAddRowItem"),$(t)).remove(),$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorAddRow"),$(r)).on("click",(function(){$(this).closest(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorAddRowItem")).before($(d).clone(!0,!0)),setPropertyGridData($(t),s,e.propertyPath,i)})),$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorContainer"),$(t)).prepend($(r).clone(!0,!0))}else $(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorAddRowItem"),$(t)).remove();let m={};s?getUtility().isUndefinedOrNull(getCurrentlySelectedFormElement().get(i+"defaultValue"))||(m=getCurrentlySelectedFormElement().get(i+"defaultValue")):getUtility().isUndefinedOrNull(getCurrentlySelectedFormElement().get(i+"defaultValue"))||(m={0:getCurrentlySelectedFormElement().get(i+"defaultValue")});const c=getCurrentlySelectedFormElement().get(i+e.propertyPath)||{},g=function(r,o){let n=!1;const i=$(d).clone(!0,!0);for(const e of Object.keys(m))if(m[e]===o){n=!0;break}$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorLabel"),$(i)).val(r),$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorValue"),$(i)).val(o),n&&$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorSelectValue"),$(i)).prop("checked",!0),e.enableAddRow?$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorAddRowItem"),$(t)).before($(i)):$(getHelper().getDomElementDataIdentifierSelector("propertyGridEditorContainer"),$(t)).prepend($(i))};if("object"===$.type(c))for(const e of Object.keys(c))g(c[e],e);else if("array"===$.type(c))for(const e in c)c.hasOwnProperty(e)&&(getUtility().isUndefinedOrNull(c[e]._label)?g(c[e],e):g(c[e]._label,c[e]._value));validateCollectionElement(i+e.propertyPath,t)}export function renderRequiredValidatorEditor(e,t,r,o){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1475417093),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1475417094),assert(getUtility().isNonEmptyString(e.validatorIdentifier),'Invalid configuration "validatorIdentifier"',1475417095),assert(getUtility().isNonEmptyString(e.label),'Invalid configuration "label"',1475417096);const n=e.validatorIdentifier;let i,l,a;getHelper().getTemplatePropertyDomElement("label",t).append(e.label),getUtility().isNonEmptyString(e.propertyPath)&&(l=getFormEditorApp().buildPropertyPath(e.propertyPath,r,o)),i=getUtility().isNonEmptyString(e.propertyValue)?e.propertyValue:"";const p=getFormEditorApp().buildPropertyPath(e.configurationOptions.validationErrorMessage.propertyPath),s=getHelper().getTemplatePropertyDomElement("validationErrorMessage",$(t)).clone();getHelper().getTemplatePropertyDomElement("validationErrorMessage",$(t)).remove();const d=function(){const r=$(s).clone(!0,!0);getEditorWrapperDomElement(t).after(r),getHelper().getTemplatePropertyDomElement("validationErrorMessage-label",r).append(e.configurationOptions.validationErrorMessage.label),getHelper().getTemplatePropertyDomElement("validationErrorMessage-fieldExplanationText",r).append(e.configurationOptions.validationErrorMessage.fieldExplanationText),a=getCurrentlySelectedFormElement().get(p),getUtility().isUndefinedOrNull(a)&&(a=[]);const o=getFirstAvailableValidationErrorMessage(e.configurationOptions.validationErrorMessage.errorCodes,a);getUtility().isUndefinedOrNull(o)||getHelper().getTemplatePropertyDomElement("validationErrorMessage-propertyPath",r).val(o),getHelper().getTemplatePropertyDomElement("validationErrorMessage-propertyPath",r).on("keyup paste",(function(){let t=getCurrentlySelectedFormElement().get(p);getUtility().isUndefinedOrNull(t)&&(t=[]),getCurrentlySelectedFormElement().set(p,renewValidationErrorMessages(e.configurationOptions.validationErrorMessage.errorCodes,t,$(this).val()))}))};-1!==getFormEditorApp().getIndexFromPropertyCollectionElement(n,"validators")&&($('input[type="checkbox"]',$(t)).prop("checked",!0),getUtility().isNonEmptyString(l)&&getCurrentlySelectedFormElement().set(l,i),d()),$('input[type="checkbox"]',$(t)).on("change",(function(){getHelper().getTemplatePropertyDomElement("validationErrorMessage",$(t)).off().empty().remove(),$(this).is(":checked")?(d(),getPublisherSubscriber().publish("view/inspector/collectionElement/new/selected",[n,"validators"]),getUtility().isNonEmptyString(l)&&getCurrentlySelectedFormElement().set(l,i)):(getPublisherSubscriber().publish("view/inspector/removeCollectionElement/perform",[n,"validators"]),getUtility().isNonEmptyString(l)&&getCurrentlySelectedFormElement().unset(l),a=getCurrentlySelectedFormElement().get(p),getUtility().isUndefinedOrNull(a)&&(a=[]),getCurrentlySelectedFormElement().set(p,renewValidationErrorMessages(e.configurationOptions.validationErrorMessage.errorCodes,a,"")))}))}export function renderCheckboxEditor(e,t,r,o){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1476218671),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1476218672),assert(getUtility().isNonEmptyString(e.label),'Invalid configuration "label"',1476218673),assert(getUtility().isNonEmptyString(e.propertyPath),'Invalid configuration "propertyPath"',1476218674),getHelper().getTemplatePropertyDomElement("label",t).append(e.label),getUtility().isNonEmptyString(e.fieldExplanationText)?getHelper().getTemplatePropertyDomElement("fieldExplanationText",t).text(e.fieldExplanationText):getHelper().getTemplatePropertyDomElement("fieldExplanationText",t).remove();const n=getFormEditorApp().buildPropertyPath(e.propertyPath,r,o),i=getCurrentlySelectedFormElement().get(n);("boolean"===$.type(i)&&i||"true"===i||1===i||"1"===i)&&$('input[type="checkbox"]',$(t)).prop("checked",!0),$('input[type="checkbox"]',$(t)).on("change",(function(){$(this).is(":checked")?getCurrentlySelectedFormElement().set(n,!0):getCurrentlySelectedFormElement().set(n,!1)}))}export function renderTextareaEditor(e,t,r,o){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1475412567),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1475412568),assert(getUtility().isNonEmptyString(e.propertyPath),'Invalid configuration "propertyPath"',1475416098),assert(getUtility().isNonEmptyString(e.label),'Invalid configuration "label"',1475416099);const n=getFormEditorApp().buildPropertyPath(e.propertyPath,r,o);getHelper().getTemplatePropertyDomElement("label",t).append(e.label),getUtility().isNonEmptyString(e.fieldExplanationText)?getHelper().getTemplatePropertyDomElement("fieldExplanationText",t).text(e.fieldExplanationText):getHelper().getTemplatePropertyDomElement("fieldExplanationText",t).remove();const i=getCurrentlySelectedFormElement().get(n);$("textarea",$(t)).val(i),$("textarea",$(t)).on("keyup paste",(function(){getCurrentlySelectedFormElement().set(n,$(this).val())}))}export function renderTypo3WinBrowserEditor(e,t,r,o){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1477300587),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1477300588),assert(getUtility().isNonEmptyString(e.label),'Invalid configuration "label"',1477300589),assert(getUtility().isNonEmptyString(e.buttonLabel),'Invalid configuration "buttonLabel"',1477318981),assert(getUtility().isNonEmptyString(e.propertyPath),'Invalid configuration "propertyPath"',1477300590),getHelper().getTemplatePropertyDomElement("label",t).append(e.label),getHelper().getTemplatePropertyDomElement("buttonLabel",t).append(e.buttonLabel),getUtility().isNonEmptyString(e.fieldExplanationText)?getHelper().getTemplatePropertyDomElement("fieldExplanationText",t).text(e.fieldExplanationText):getHelper().getTemplatePropertyDomElement("fieldExplanationText",t).remove(),$("form",$(t)).prop("name",e.propertyPath),Icons.getIcon(e.iconIdentifier,Icons.sizes.small).then((function(e){getHelper().getTemplatePropertyDomElement("image",t).append($(e))})),getHelper().getTemplatePropertyDomElement("onclick",t).on("click",(function(){const t=Math.floor(1e5*Math.random()+1);$(this).closest(getHelper().getDomElementDataIdentifierSelector("editorControlsWrapper")).find(getHelper().getDomElementDataAttribute("contentElementSelectorTarget","bracesWithKey")).attr(getHelper().getDomElementDataAttribute("contentElementSelectorTarget"),t),openTypo3WinBrowser("db",t+"|||"+e.browsableType)})),listenOnElementBrowser();const n=getFormEditorApp().buildPropertyPath(e.propertyPath,r,o),i=getCurrentlySelectedFormElement().get(n);validateCollectionElement(n,t),getHelper().getTemplatePropertyDomElement("propertyPath",t).val(i),getHelper().getTemplatePropertyDomElement("propertyPath",t).on("keyup paste",(function(){getCurrentlySelectedFormElement().set(n,$(this).val()),validateCollectionElement(n,t)}))}export function renderRemoveElementEditor(e,t,r,o){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1475412563),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1475412564),getUtility().isUndefinedOrNull(r)?$("button",$(t)).addClass(getHelper().getDomElementClassName("buttonFormElementRemove")+" "+getHelper().getDomElementClassName("buttonFormEditor")):$("button",$(t)).addClass(getHelper().getDomElementClassName("buttonCollectionElementRemove")),$("button",$(t)).on("click",(function(){getUtility().isUndefinedOrNull(r)?getViewModel().showRemoveFormElementModal():getViewModel().showRemoveCollectionElementModal(r,o)}))}export function renderFormElementSelectorEditorAddition(e,t,r){assert("object"===$.type(e),'Invalid parameter "editorConfiguration"',1484574704),assert("object"===$.type(t),'Invalid parameter "editorHtml"',1484574705),assert(getUtility().isNonEmptyString(r),'Invalid parameter "propertyPath"',1484574706);const o=$(getHelper().getDomElementDataIdentifierSelector("formElementSelectorControlsWrapper"),t);if(!0===e.enableFormelementSelectionButton){if(0===o.length)return;const e=$(getHelper().getDomElementDataIdentifierSelector("formElementSelectorSplitButtonListContainer"),t);e.off().empty();const n=getFormEditorApp().getNonCompositeNonToplevelFormElements();0===n.length?Icons.getIcon(getHelper().getDomElementDataAttributeValue("iconNotAvailable"),Icons.sizes.small,null,Icons.states.default).then((function(t){const r=$('<li data-no-sorting><a href="#"></a></li>');r.append($(t)).append(" "+getFormElementDefinition(getRootFormElement(),"inspectorEditorFormElementSelectorNoElements")),e.append(r)})):$.each(n,(function(o,n){Icons.getIcon(getFormElementDefinition(n,"iconIdentifier"),Icons.sizes.small,null,Icons.states.default).then((function(o){const i=$('<li data-no-sorting><a href="#" class="dropdown-item" data-formelement-identifier="'+n.get("identifier")+'"></a></li>');$(selector`[data-formelement-identifier="${n.get("identifier")}"]`,i).append($(o)).append(" "+n.get("label")),$("a",i).on("click",(function(){let e;e=getCurrentlySelectedFormElement().get(r)||"",e=0===e.length?"{"+$(this).attr("data-formelement-identifier")+"}":e+" {"+$(this).attr("data-formelement-identifier")+"}",getCurrentlySelectedFormElement().set(r,e),getHelper().getTemplatePropertyDomElement("propertyPath",t).val(e),validateCollectionElement(r,t)})),e.append(i)}))}))}else $(getHelper().getDomElementDataIdentifierSelector("editorControlsInputGroup"),t).removeClass(getHelper().getDomElementClassName("inspectorInputGroup")),o.off().empty().remove()}export function buildTitleByFormElement(e){let t;getUtility().isUndefinedOrNull(e)&&(e=getCurrentlySelectedFormElement()),assert("object"===$.type(e),'Invalid parameter "formElement"',1478967319),t="Form"===e.get("type")?e.get("type"):getFormElementDefinition(e,"label")?getFormElementDefinition(e,"label"):e.get("identifier");const r=document.createElement("span");return r.textContent=t,r}export function bootstrap(e,t){return formEditorApp=e,configuration=$.extend(!0,defaultConfiguration,t||{}),Helper.bootstrap(formEditorApp),this}